/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_iprobe.c,v 1.9 2005/06/29 00:23:16 eugene Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t 
mx_iprobe(mx_endpoint_t endpoint,
	  uint64_t match_info,
	  uint64_t match_mask,
          mx_status_t *status,
	  uint32_t *result)
{
  
  struct mx_queued_msg *msg;

  pthread_mutex_lock(&Mx_rx_lock);

  for(msg = endpoint->queued_messages.next;
      msg != &endpoint->queued_messages;
      msg = msg->next){
    if (((msg->match_info & match_mask) == match_info) &&
	((msg->type == MX_SR_TYPE_SEND) ||
	 (msg->type == MX_SR_TYPE_ISSEND))) {
      if (status != NULL){
        status->source = msg->source;
        status->msg_length = msg->length;
	status->match_info = msg->match_info;
      }
      pthread_mutex_unlock(&Mx_rx_lock);
      *result = 1;
      return MX_SUCCESS;
    }
  }
  pthread_mutex_unlock(&Mx_rx_lock);
  *result = 0;
  return MX_SUCCESS;
}
